<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Sso\WebserviceBundle\Model\Request\User;

use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;

class ChangePassword extends Base
{

    /**
     * @var UserModel
     */
    protected $userUpdateModel;

    /**
     * Init user model
     * @param \SimpleXMLElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->_factoryUser($simpleXML->Value->UserType->children()));
        $this->setUserUpdateModel($this->_factoryUserKey($simpleXML->Key->UserType->children()));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUser($xml)
    {
        // Do not validate the new user data. This will be done right before save
        return $this->typeF->user($xml, array('User_ChangePassword'));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUserKey($xml)
    {
        // Validate user data to find user in database
        $validationGroups = $this->userIdentifyValdiationGroups($xml);
        array_push($validationGroups, 'User_Update');
        return $this->typeF->user($xml, $validationGroups);
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
                . '<UserType required="true">'
                . '<Identifier />'
                . '<Guid />'
                . '<Username />'
                . '<Email />'
                . '</UserType>'
                . '</Key>'
                . '<Value required="true">'
                . '<UserType>'
                . '<Password required="true"></Password>'
                . '</UserType>'
                . '</Value>';
    }

    /**
     * Set user model
     * @param UserModel $userModel
     */
    public function setUserUpdateModel(UserModel $userModel)
    {
        $this->userUpdateModel = $userModel;
    }

    /**
     * Get user model
     * @return UserModel
     */
    public function getUserUpdateModel()
    {
        return $this->userUpdateModel;
    }

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->userUpdateModel) {
            $errors = array_merge($errors, $this->userUpdateModel->errors()->getErrors());
        }
        return $errors;
    }
}
