<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

namespace Sso\WebserviceBundle\Model\Request\User;

use Sso\WebserviceBundle\Model\Type\Factory as TypeFactory;
use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Exception\Type\Base as BaseException;
use Sso\WebserviceBundle\Model\Request\User;

class Factory
{

    /**
     * Factory object
     * @var TypeFactory
     */
    protected $typeF;

    /**
     * Api Manager
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->typeF = new TypeFactory($this->apiM);
    }

    /**
     * Show user factory
     * @param \SimpleXMLElement $simpleXML
     * @return User\Show
     */
    public function show($simpleXML)
    {
        $model = new User\Show($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Add user factory
     * @param \SimpleXMLElement $simpleXML
     * @return User\Add
     */
    public function add($simpleXML)
    {
        $model = new User\Add($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Delete user factory
     * @param \SimpleXMLElement $simpleXML
     * @return User\Delete
     */
    public function delete($simpleXML)
    {
        $model = new User\Delete($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Update user factory
     * @param \SimpleXMLElement $simpleXML
     * @return User\Update
     */
    public function update($simpleXML)
    {
        $model = new User\Update($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Change users password factory
     * @param \SimpleXMLElement $simpleXML
     * @return User\ChangePassword
     */
    public function changePassword($simpleXML)
    {
        $model = new User\ChangePassword($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }
}
