<?php

/**
 * User update
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\User;

use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;

/**
 * User update
 */
class Update extends Base
{

    /**
     * @var UserModel
     */
    protected $userUpdateModel;

    /**
     * Init user model
     * @param \SimpleXMLElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->_factoryUser($simpleXML->Value->UserType->children()));
        $this->setUserUpdateModel($this->_factoryUserKey($simpleXML->Key->UserType->children()));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUser($xml)
    {
        // Do not validate the new user data. This will be done right before save
        return $this->typeF->user($xml, array('None'));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUserKey($xml)
    {
        // Validate user data to find user in database
        $validationGroups = $this->userIdentifyValdiationGroups($xml);
        array_push($validationGroups, 'User_Update');
        return $this->typeF->user($xml, $validationGroups);
    }

    /**
     * Set user model
     * @param UserModel $userModel
     */
    public function setUserUpdateModel(UserModel $userModel)
    {
        $this->userUpdateModel = $userModel;
    }

    /**
     * Get user model
     * @return UserModel
     */
    public function getUserUpdateModel()
    {
        return $this->userUpdateModel;
    }

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->userUpdateModel) {
            $errors = array_merge($errors, $this->userUpdateModel->errors()->getErrors());
        }
        return $errors;
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
                . '<UserType required="true">'
                . '<Identifier />'
                . '<Guid />'
                . '<Username />'
                . '<Email />'
                . '</UserType>'
                . '</Key>'
                . '<Value required="true">'
                . '<UserType required="true">'
                . '<Email></Email>'
                . '<Username></Username>'
                . '<Firstname></Firstname>'
                . '<Lastname></Lastname>'
                . '<Active></Active>'
                . '<Deleted></Deleted>'
                . '<LastLogonTime></LastLogonTime>'
                . '<AuthId></AuthId>'
                . '<LdapSearchAttributes></LdapSearchAttributes>'
                . '<LdapSearchValue></LdapSearchValue>'
                . '<MfaEnabled></MfaEnabled>'
                . '<MfaRecreate></MfaRecreate>'
                . '<ActivateTokenRecreate></ActivateTokenRecreate>'
                . '</UserType>'
                . '</Value>';
    }
}
