<?php

/**
 * User application request factory 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplication;

use Sso\WebserviceBundle\Model\Type\Factory as TypeFactory;
use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Exception\Type\Base as BaseException;
use Sso\WebserviceBundle\Model\Request\UserApplication;

/**
 * User application request factory
 */
class Factory
{

    /**
     * Factory object
     * @var TypeFactory
     */
    protected $typeF;

    /**
     * Api Manager
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->typeF = new TypeFactory($this->apiM);
    }

    /**
     * Show user application factory
     * @param \DOMElement $simpleXML
     * @return UserApplication\Show
     */
    public function show($simpleXML)
    {
        $model = new UserApplication\Show($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Show user application factory
     * @param \DOMElement $simpleXML
     * @return UserApplication\ShowDetails
     */
    public function showDetails($simpleXML)
    {
        $model = new UserApplication\ShowDetails($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Add user application factory
     * @param \DOMElement $simpleXML
     * @return UserApplication\Add
     */
    public function add($simpleXML)
    {
        $model = new UserApplication\Add($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Delete user application factory
     * @param \DOMElement $simpleXML
     * @return UserApplication\Delete
     */
    public function delete($simpleXML)
    {
        $model = new UserApplication\Delete($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }
}
