<?php

/**
 * User application request
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserApplication;

/**
 * User request show users applications
 */
class Show extends Base
{

    /**
     * Init models
     * @param \DOMElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->_factoryUser($simpleXML->Key->UserType->children()));
        if (property_exists($simpleXML->Key, 'ApplicationType')) {
            $this->setUserApplicationModel($this->_factoryUserApplication($simpleXML->Key->ApplicationType->children()));
        }
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUser($xml)
    {
        $validationGroups = $this->userIdentifyValdiationGroups($xml);
        array_push($validationGroups, 'UserApplication_Show');
        return $this->typeF->user($xml, $validationGroups);
    }

    /**
     * Build user application object
     * @param \DOMElement $xml
     * @return UserApplicationModel
     */
    protected function _factoryUserApplication($xml)
    {
        return $this->typeF->userApplication($xml, array('UserApplication_Show'));
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
                . '<UserType required="true">'
                . '<Identifier />'
                . '<Guid />'
                . '<Username />'
                . '<Email />'
                . '</UserType>'
                . '<ApplicationType>'
                . '<Active />'
                . '</ApplicationType>'
                . '</Key>';
    }
}
