<?php

/**
 * User application role request factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserSearch;

use Sso\WebserviceBundle\Model\Type\Factory as TypeFactory;
use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Exception\Type\Base as BaseException;
use Sso\WebserviceBundle\Model\Request\UserSearch;

/**
 * User application role request factory
 */
class Factory
{

    /**
     * Factory object
     * @var TypeFactory
     */
    protected $typeF;

    /**
     * Api Manager
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->typeF = new TypeFactory($this->apiM);
    }

    /**
     * Find users by application
     * @param \DOMElement $simpleXML
     * @return UserSearch\FindByApplication
     */
    public function findByApplication($simpleXML)
    {
        $model = new UserSearch\FindByApplication($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Find users by application-attribute-value
     * @param \DOMElement $simpleXML
     * @return UserSearch\FindByApplicationAttribute
     */
    public function findByApplicationAttribute($simpleXML)
    {
        $model = new UserSearch\FindByApplicationAttribute($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Find users by application-role-value
     * @param \DOMElement $simpleXML
     * @return UserSearch\FindByApplicationRole
     */
    public function findByApplicationRole($simpleXML)
    {
        $model = new UserSearch\FindByApplicationRole($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }
}
