<?php

/**
 * UserSearch request for finding users by attribute value
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserSearch;

use Sso\WebserviceBundle\Entity\Webservice\Type\Application as ApplicationModel;
use Sso\WebserviceBundle\Entity\Webservice\Type\UserApplication as UserApplicationModel;
use Sso\WebserviceBundle\Api\Error\Type\External as ExternalError;

/**
 * UserSearch request
 */
class FindByApplication extends Base
{

    /**
     * Application
     * @var \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    protected $applicationModel;

    /**
     * @var boolean|null
     */
    protected $userApplicationActive;

    /**
     * The search result: GUIDs
     * @var array
     */
    protected $userGuids;

    /**
     * @var \DateTime
     */
    protected $modifiedAfter;

    /**
     * Init application model
     * @param \SimpleXMLElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setApplicationModel($this->_factoryApplication($simpleXML->Key->ApplicationType->children()));

        if (property_exists($simpleXML->Key->ApplicationType, 'Active')) {
            $this->userApplicationActive = (boolean)(int)$simpleXML->Key->ApplicationType->Active;
        }

        if (property_exists($simpleXML->Key->UserType, 'ModifiedAfter')) {
            $this->setModifiedAfterObject((string)$simpleXML->Key->UserType->ModifiedAfter);
        }
    }

    /**
     * List of errors
     * @return array
     */
    public function getErrors()
    {
        $errors = parent::getErrors();
        if ($this->applicationModel) {
            $errors = array_merge($errors, $this->applicationModel->errors()->getErrors());
        }

        return $errors;
    }

    /**
     * @param ApplicationModel $applicationModel
     */
    public function setApplicationModel(ApplicationModel $applicationModel)
    {
        $this->applicationModel = $applicationModel;
    }

    /**
     * @return ApplicationModel
     */
    public function getApplicationModel()
    {
        return $this->applicationModel;
    }

    /**
     * @return boolean|null
     */
    public function getUserApplicationActive()
    {
        return $this->userApplicationActive;
    }

    /**
     * Build application object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    protected function _factoryApplication($xml)
    {
        // Validate for add
        return $this->typeF->application($xml, array('UserSearch_FindByApplication'));
    }

    /**
     * @param string $dateSting
     */
    public function setModifiedAfterObject($dateSting)
    {

        try {
            $this->modifiedAfter = new \DateTime($dateSting);
        } catch (\Exception $exc) {
            $this->modifiedAfter = null;
            $this->errors()->addError(new ExternalError('df1', 'WrongDateFormat'));
        }
    }

    /**
     * @return \DateTime|null
     */
    public function getModifiedAfter()
    {
        return $this->modifiedAfter;
    }

    /**
     * Build user application object
     * @param \DOMElement $xml
     * @return UserApplicationModel
     */
    protected function _factoryUserApplication($xml)
    {
        return $this->typeF->userApplication($xml, array('UserSearch_FindByApplication'));
    }

    /**
     * Set result
     * @param array $guids
     */
    public function setSearchResult($guids)
    {
        $this->userGuids = (array)$guids;
    }

    /**
     * List of User-GUIDs
     * @return array
     */
    public function getSearchResult()
    {
        return $this->userGuids;
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
        .'<UserType>'
        .'<ModifiedAfter/>'
        .'</UserType>'
        .'<ApplicationType required="true">'
        .'<Name required="true"></Name>'
        .'<Active/>'
        .'</ApplicationType>'
        .'</Key>';
    }
}
