<?php

/**
 * User service request factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserService;

use Sso\WebserviceBundle\Model\Type\Factory as TypeFactory;
use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Exception\Type\Base as BaseException;
use Sso\WebserviceBundle\Model\Request\UserService;

/**
 * User service request factory
 */
class Factory
{

    /**
     * Factory object
     * @var TypeFactory
     */
    protected $typeF;

    /**
     * Api Manager
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
        $this->typeF = new TypeFactory($this->apiM);
    }

    /**
     * Show user factory
     * @param \DOMElement $simpleXML
     * @return UserService\PasswordRequest
     */
    public function passwordRequest($simpleXML)
    {
        $model = new UserService\PasswordRequest($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Add user factory
     * @param \DOMElement $simpleXML
     * @return UserService\PasswordConfirm
     */
    public function passwordConfirm($simpleXML)
    {
        $model = new UserService\PasswordConfirm($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * User activate factory
     * @param \DOMElement $simpleXML
     * @return UserService\ActivateRequest
     */
    public function activateRequest($simpleXML)
    {
        $model = new UserService\ActivateRequest($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * Add user factory
     * @param \DOMElement $simpleXML
     * @return UserService\ActivateConfirm
     */
    public function activateConfirm($simpleXML)
    {
        $model = new UserService\ActivateConfirm($this->typeF);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }
}
