<?php

/**
 * User request for password confirm
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Request\UserService;

use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;

/**
 * User request for password confirm
 */
class PasswordConfirm extends Base
{

    /**
     * @var UserModel
     */
    protected $userUpdateModel;

    /**
     * Init user model
     * @param \DOMElement $simpleXML
     */
    public function init($simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->_factoryUser($simpleXML->Value->UserType->children()));
        $this->setUserUpdateModel($this->_factoryUserUpdate($simpleXML->Key->UserType->children()));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUser($xml)
    {
        // Validate for add
        return $this->typeF->user($xml, array('UserService_PasswordConfirm'));
    }

    /**
     * Build user object
     * @param \DOMElement $xml
     * @return \Sso\WebserviceBundle\Entity\Webservice\Type\User
     */
    protected function _factoryUserUpdate($xml)
    {
        // Validate user data to find user in database
        return $this->typeF->user($xml, array('User_Update'));
    }

    /**
     * Set user model
     * @param UserModel $userModel
     */
    public function setUserUpdateModel(UserModel $userModel)
    {
        $this->userUpdateModel = $userModel;
    }

    /**
     * Get user model
     * @return UserModel
     */
    public function getUserUpdateModel()
    {
        return $this->userUpdateModel;
    }

    /**
     * Returns a list of allowed field names in xml
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
        .'<UserType required="true">'
        .'<Email required="true"></Email>'
        .'<PasswordToken required="true"></PasswordToken>'
        .'</UserType>'
        .'</Key>'
        .'<Value required="true">'
        .'<UserType required="true">'
        .'<Password required="true"></Password>'
        .'</UserType>'
        .'</Value>';
    }
}
