<?php

/**
 * Application response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\Application;

use Sso\WebserviceBundle\Model\Response\Base as ResponseBase;
use Sso\WebserviceBundle\Model\Request;

/**
 * Application response base class
 */
abstract class Base extends ResponseBase
{
    /**
     * Application model
     * @var \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    protected $application;

    /**
     * Get response for application-show
     * @param Request\Base $requestModel
     */
    public function createResponse(Request\Base $requestModel)
    {
        $this->application = $requestModel->getApplicationModel();
        $this->buildResponse($requestModel);
    }
}
