<?php

/**
 * Attribute response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\ApplicationAttribute;

use Sso\WebserviceBundle\Model\Response\Base as ResponseBase;
use Sso\WebserviceBundle\Model\Request;

/**
 * Attribute response base class
 */
abstract class Base extends ResponseBase
{
    /**
     * Attribute model
     * @var \Sso\WebserviceBundle\Entity\Webservice\Type\Attribute
     */
    protected $attribute;

    /**
     * Get response for application-show
     * @param Request\Base $requestModel
     */
    public function createResponse(Request\Base $requestModel)
    {
        $this->attribute = $requestModel->getAttributeModel();
        $this->buildResponse($requestModel);
    }
}
