<?php

/**
 * Application response for showing application attribute
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\ApplicationAttribute;

/**
 * Application response
 */
class Show extends Base
{

    /**
     * Returns response status
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return (boolean)$this->attribute;
    }

    /**
     * Returns response message
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->attribute ? false : 'Application attribute not found';
    }

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        if (!$this->attribute) {
            parent::buildResponseBody($xmlContainer);

            return;
        }
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('ApplicationAttributeType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Name', $this->attribute->getName()));
        $typeElement->appendChild($document->createTextElement('Type', $this->attribute->getType()));
    }
}
