<?php

/**
 * Respnose factory 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response;

use Sso\WebserviceBundle\Api\Response\Builder as XmlResponse;

/**
 * Response factory class
 */
class Factory
{

    /**
     * Xml response document
     * @var XmlResponse
     */
    private $xmlResponse;

    /**
     * List of factories
     * @var array
     */
    protected $factories;

    /**
     * Constructor
     * @param XmlResponse $xmlResponse
     */
    public function __construct(XmlResponse $xmlResponse)
    {
        $this->xmlResponse = $xmlResponse;
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\Application\Factory
     */
    public function application()
    {
        return $this->_getFactory(__NAMESPACE__ . '\Application\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\ApplicationAttribute\Factory
     */
    public function applicationAttribute()
    {
        return $this->_getFactory(__NAMESPACE__ . '\ApplicationAttribute\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\ApplicationRole\Factory
     */
    public function applicationRole()
    {
        return $this->_getFactory(__NAMESPACE__ . '\ApplicationRole\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\User\Factory
     */
    public function user()
    {
        return $this->_getFactory(__NAMESPACE__ . '\User\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\UserApplication\Factory
     */
    public function userApplication()
    {
        return $this->_getFactory(__NAMESPACE__ . '\UserApplication\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\UserApplicationAttribute\Factory
     */
    public function userApplicationAttribute()
    {
        return $this->_getFactory(__NAMESPACE__ . '\UserApplicationAttribute\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\UserApplicationRole\Factory
     */
    public function userApplicationRole()
    {
        return $this->_getFactory(__NAMESPACE__ . '\UserApplicationRole\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\UserService\Factory
     */
    public function userService()
    {
        return $this->_getFactory(__NAMESPACE__ . '\UserService\Factory');
    }

    /**
     * @return \Sso\WebserviceBundle\Model\Response\UserSearch\Factory
     */
    public function userSearch()
    {
        return $this->_getFactory(__NAMESPACE__ . '\UserSearch\Factory');
    }

    /**
     * Returns factory
     * @param string $class
     * @return 
     */
    protected function _getFactory($class)
    {
        return isset($this->factories[$class]) ? $this->factories[$class] : ($this->factories[$class] = new $class($this->xmlResponse));
    }
}
