<?php

/**
 * User response factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\User;

use Sso\WebserviceBundle\Model\Response\BaseFactory;
use Sso\WebserviceBundle\Model\Response\User as Response;
use Sso\WebserviceBundle\Model\Request\User as Request;

/**
 * User response factory
 */
class Factory extends BaseFactory
{

    /**
     * @param Request\Show $requestModel
     */
    public function show(Request\Show $requestModel)
    {
        $model = new Response\Show($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\Add $requestModel
     */
    public function add(Request\Add $requestModel)
    {
        $model = new Response\Add($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\Update $requestModel
     */
    public function update(Request\Update $requestModel)
    {
        $model = new Response\Update($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\ChangePassword $requestModel
     */
    public function changePassword(Request\ChangePassword $requestModel)
    {
        $model = new Response\ChangePassword($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\Delete $requestModel
     */
    public function delete(Request\Delete $requestModel)
    {
        $model = new Response\Delete($this->xmlResponse);
        $model->createResponse($requestModel);
    }
}
