<?php

/**
 * User application response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserApplication;

use Sso\WebserviceBundle\Model\Response\User\Base as ResponseBase;
use Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * User application response base class
 */
abstract class Base extends ResponseBase
{
    /**
     * Add user model to response
     * @param \DOMElement $xmlContainer
     * @param Type\User $user
     */
    protected function _addUserResponse($xmlContainer, Type\User $user)
    {
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('UserType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Username', $user->getUsername()));
        $typeElement->appendChild($document->createTextElement('Email', $user->getEmail()));
    }

    /**
     * Add user details model to response
     * @param \DOMElement $xmlContainer
     * @param Type\User $user
     */
    protected function _addUserDetailsResponse($xmlContainer, Type\User $user)
    {
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('UserType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Guid', $user->getGuid()));
        $typeElement->appendChild($document->createTextElement('Username', $user->getUsername()));
        $typeElement->appendChild($document->createTextElement('Email', $user->getEmail()));
        $typeElement->appendChild($document->createTextElement('Firstname', $user->getFirstname()));
        $typeElement->appendChild($document->createTextElement('Lastname', $user->getLastname()));
        $typeElement->appendChild($document->createTextElement('AuthId', $user->getAuthId()));
        $typeElement->appendChild($document->createTextElement('Active', $user->getActive()));
        $typeElement->appendChild($document->createTextElement('Deleted', $user->getDeleted() ? 1 : 0));
    }

    /**
     * Add application model to response
     * @param \DOMElement $xmlContainer
     * @param Type\Application $userApplication
     */
    protected function _addApplicationResponse($xmlContainer, Type\UserApplication $userApplication)
    {
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('ApplicationType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Name', $userApplication->getName()));
        $typeElement->appendChild($document->createBoolElement('Active', $userApplication->getActive()));
    }

    /**
     * Add application model to response
     * @param \DOMElement $xmlContainer
     * @param Type\Application $userApplication
     */
    protected function _addApplicationWithAttributesRolesResponse($xmlContainer, Type\UserApplication $userApplication)
    {
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('ApplicationType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Name', $userApplication->getName()));
        $typeElement->appendChild($document->createBoolElement('Active', $userApplication->getActive()));

        foreach ($userApplication->getAttributes() as $userApplicationAttribute) {
            $this->_addAttributeResponse($typeElement, $userApplicationAttribute);
        }

        foreach ($userApplication->getRoles() as $userApplicationRole) {
            $this->_addRoleResponse($typeElement, $userApplicationRole);
        }
    }

    /**
     * Add attribute value to response
     * @param \DOMElement $xmlContainer
     * @param Type\UserApplicationAttribute $userApplicationAttribute
     */
    protected function _addAttributeResponse($xmlContainer, Type\UserApplicationAttribute $userApplicationAttribute)
    {
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('AttributeType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Type', $userApplicationAttribute->getType()));
        $typeElement->appendChild($document->createTextElement('Name', $userApplicationAttribute->getName()));
        $typeElement->appendChild($document->createTextElement('Value', $userApplicationAttribute->getValue()));
    }

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function _addRoleResponse(\DOMElement $xmlContainer, Type\UserApplicationRole $userApplicationRole)
    {
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('ApplicationRoleType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Name', $userApplicationRole->getName()));
        $typeElement->appendChild(
            $document->createTextElement('Description', $userApplicationRole->getRole()->getDescription())
        );
    }
}
