<?php

/**
 * User application attribute response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserApplicationAttribute;

use Sso\WebserviceBundle\Model\Response\UserApplication\Base as ResponseBase;
use Sso\WebserviceBundle\Model\Request;
use Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * User application attribute response base class
 */
abstract class Base extends ResponseBase
{
    /**
     * Get response for application-show
     * @param Request\Base $requestModel
     */
    public function createResponse(Request\Base $requestModel)
    {
        $this->userApplication = $requestModel->getUserApplicationModel();
        parent::createResponse($requestModel);
    }

    /**
     * Add attribute value to response
     * @param \DOMElement $xmlContainer
     * @param Type\UserApplicationAttribute $userApplicationAttribute
     */
    protected function _addAttributeResponse($xmlContainer, Type\UserApplicationAttribute $userApplicationAttribute)
    {
        $document = $this->xmlResponse->document();
        $typeElement = $document->createElement('AttributeType');
        $xmlContainer->appendChild($typeElement);

        $typeElement->appendChild($document->createTextElement('Type', $userApplicationAttribute->getType()));
        $typeElement->appendChild($document->createTextElement('Name', $userApplicationAttribute->getName()));
        $typeElement->appendChild($document->createTextElement('Value', $userApplicationAttribute->getValue()));
    }
}
