<?php

/**
 * User response for adding new user
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserApplicationRole;

use Sso\WebserviceBundle\Model\Response\BaseFactory;
use Sso\WebserviceBundle\Model\Response\UserApplicationRole as Response;
use Sso\WebserviceBundle\Model\Request\UserApplicationRole as Request;

/**
 * Factory for user application role
 */
class Factory extends BaseFactory
{

    /**
     * @param Request\Show $requestModel
     */
    public function show(Request\Show $requestModel)
    {
        $model = new Response\Show($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\Add $requestModel
     */
    public function add(Request\Add $requestModel)
    {
        $model = new Response\Add($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\Delete $requestModel
     */
    public function delete(Request\Delete $requestModel)
    {
        $model = new Response\Delete($this->xmlResponse);
        $model->createResponse($requestModel);
    }
}
