<?php

/**
 * User response for showing user data
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserApplicationRole;

use Sso\WebserviceBundle\Model\Request;

/**
 * User response
 */
class Show extends Base
{

    /**
     * User application module
     * @var \Sso\WebserviceBundle\Entity\Webservice\Type\UserApplication
     */
    private $userApplication;

    /**
     * Application model
     * @var \Sso\WebserviceBundle\Entity\Webservice\Type\Application
     */
    private $application;

    /**
     * Get response for application-show
     * @param Request\Base $requestModel
     */
    public function createResponse(Request\Base $requestModel)
    {
        $this->application = $requestModel->getApplicationModel();
        $this->userApplication = $requestModel->getUserApplicationModel();
        parent::createResponse($requestModel);
    }

    /**
     * Returns response status
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return $this->user && $this->application && $this->userApplication;
    }

    /**
     * Returns response message
     * @return string
     */
    protected function getResponseMessage()
    {
        $messages = array();
        if (!$this->user) {
            $messages[] = 'User not found';
        }
        if (!$this->application) {
            $messages[] = 'Application not found';
        }
        if (!$this->userApplication) {
            $messages[] = 'Roles not found';
        }

        return 0 == count($messages) ? false : implode(', ', $messages);
    }

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        if ($this->user && $this->application && $this->userApplication) {
            $this->_addUserResponse($xmlContainer, $this->user);
            $this->_addApplicationResponse($xmlContainer, $this->userApplication);
            foreach ($this->userApplication->getRoles() as $userApplicationRole) {
                $this->_addRoleResponse($xmlContainer, $userApplicationRole);
            }
        }
    }
}
