<?php

/**
 * User service request factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserSearch;

use Sso\WebserviceBundle\Model\Response\BaseFactory;
use Sso\WebserviceBundle\Model\Response\UserSearch as Response;
use Sso\WebserviceBundle\Model\Request\UserSearch as Request;

class Factory extends BaseFactory
{

    /**
     * @param Request\FindByApplication $requestModel
     */
    public function findByApplication(Request\FindByApplication $requestModel)
    {
        $model = new Response\FindByApplication($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\FindByApplicationAttribute $requestModel
     */
    public function findByApplicationAttribute(Request\FindByApplicationAttribute $requestModel)
    {
        $model = new Response\FindByApplicationAttribute($this->xmlResponse);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\FindByApplicationRole $requestModel
     */
    public function findByApplicationRole(Request\FindByApplicationRole $requestModel)
    {
        $model = new Response\FindByApplicationRole($this->xmlResponse);
        $model->createResponse($requestModel);
    }
}
