<?php

/**
 * User service response for requesting password change token
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Response\UserService;

use Sso\WebserviceBundle\Model\Request;

/**
 * User service response for requesting password change token
 */
class PasswordRequest extends Base
{

    /**
     * Returns response status
     * @return string|bool
     */
    protected function getResponseStatus()
    {
        return (boolean)$this->user;
    }

    /**
     * Returns response message
     * @return string
     */
    protected function getResponseMessage()
    {
        return $this->user ? false : 'User not found';
    }

    /**
     * Build response body
     * @param \DOMElement $xmlContainer
     */
    protected function buildResponseBody(\DOMElement $xmlContainer)
    {
        parent::buildResponseBody($xmlContainer);
        if ($this->user) {
            $document = $this->xmlResponse->document();
            $user = $document->createElement('UserType');
            $xmlContainer->appendChild($user);

            $user->appendChild($document->createTextElement('Username', $this->user->getUsername()));
            $user->appendChild($document->createTextElement('Email', $this->user->getEmail()));
            $user->appendChild($document->createTextElement('PasswordToken', $this->user->getPasswordToken()));
            $user->appendChild($document->createTextElement(
                'PasswordTokenExpire',
                $this->user->getPasswordTokenExpire()->format('Y-m-d H:i:s')
            ));
        }
    }
}
