<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model;

/**
 * Trait ResponseStatusTrait
 * @package Sso\WebserviceBundle\Model
 */
trait ResponseStatusTrait
{
    /**
     * @param int $statusCode
     * @return string
     */
    private function statusCodeToStatus(int $statusCode): string
    {
        $responseStatus = [
            200 => 'OK',
            400 => 'Bad Request',
            401 => 'Unauthorized',
            403 => 'Forbidden',
            404 => 'Not Found',
            406 => 'Not Acceptable',
            500 => 'Internal Server Error',
        ];
        return isset($responseStatus[$statusCode]) ? $responseStatus[$statusCode] : $responseStatus[500];
    }
}
