<?php

/**
 * Model factory class
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Model\Type;

use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Exception\Type\Base as BaseException;
use Sso\WebserviceBundle\Entity\Webservice\Type;

/**
 * Model factory class
 */
class Factory
{

    /**
     * @var ApiManager
     */
    protected $apiM;

    /**
     *  Constructor
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @param \DOMElement $userData
     * @param array|null $validationGroups Null for full validation, array of group-name(s) for group specific validation
     * @return Type\User
     */
    public function user($userData, $validationGroups = null)
    {
        $model = new Type\User($this->apiM->validator());

        // For backwards compatibility because password-encrypt-type is not supported by every version
        $model->setDefaultPasswordEncryptType($this->apiM->passwordCryptRepository()->getDefault()->getEncryptType());

        try {
            $model->init($userData, $validationGroups);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * @param \DOMElement $applicationData
     * @param array|null $validationGroups Null for full validation, array of group-name(s) for group specific validation
     * @return Type\Application
     */
    public function application($applicationData, $validationGroups = null)
    {
        $model = new Type\Application($this->apiM->validator());
        try {
            $model->init($applicationData, $validationGroups);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * @param \DOMElement $roleData
     * @param array|null $validationGroups Null for full validation, array of group-name(s) for group specific validation
     * @return Type\Role
     */
    public function role($roleData, $validationGroups = null)
    {
        $model = new Type\Role($this->apiM->validator());
        try {
            $model->init($roleData, $validationGroups);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * @param \DOMElement $attributeData
     * @param array|null $validationGroups Null for full validation, array of group-name(s) for group specific validation
     * @return Type\Attribute
     */
    public function attribute($attributeData, $validationGroups = null)
    {
        $model = new Type\Attribute($this->apiM->validator());
        try {
            $model->init($attributeData, $validationGroups);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * @param \DOMElement $applicationData
     * @param array|null $validationGroups Null for full validation, array of group-name(s) for group specific validation
     * @return Type\UserApplication
     */
    public function userApplication($applicationData, $validationGroups = null)
    {
        $model = new Type\UserApplication($this->apiM->validator());
        try {
            $model->init($applicationData, $validationGroups);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * @param \DOMElement $roleData
     * @param array|null $validationGroups Null for full validation, array of group-name(s) for group specific validation
     * @return Type\UserApplicationRole
     */
    public function userApplicationRole($roleData, $validationGroups = null)
    {
        $model = new Type\UserApplicationRole($this->apiM->validator());
        try {
            $model->init($roleData, $validationGroups);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }

    /**
     * @param \DOMElement $attributeData
     * @param array|null $validationGroups Null for full validation, array of group-name(s) for group specific validation
     * @return Type\UserApplicationAttribute
     */
    public function userApplicationAttribute($attributeData, $validationGroups = null)
    {
        $model = new Type\UserApplicationAttribute($this->apiM->validator());
        try {
            $model->init($attributeData, $validationGroups);
        } catch (BaseException $exc) {
            unset($exc);
        }

        return $model;
    }
}
