<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\PasswordCrypt;

/**
 * Class PasswordCryptBase64Sha256
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\PasswordCrypt
 */
class PasswordCryptBase64Sha256 implements PasswordCryptInterface
{
    const PASSWORD_HASH_COST = 10;

    /**
     * @return string
     */
    public function getEncryptType(): string
    {
        return 'base64sha256';
    }

    /**
     * @param string $password
     * @return string|bool
     */
    public function passwordHash(string $password)
    {
        return password_hash(
            base64_encode(hash('sha256', $password, true)),
            PASSWORD_BCRYPT,
            ['cost' => static::PASSWORD_HASH_COST]
        );
    }

    /**
     * @param string $password
     * @param string $hash
     * @return bool
     */
    public function passwordVerify(string $password, string $hash): bool
    {
        return password_verify(
            base64_encode(hash('sha256', $password, true)),
            $hash
        );
    }
}
