<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\PasswordCrypt;

use Sso\WebserviceBundle\Entity\Webservice\Type\User;
use Sso\WebserviceBundle\Exception\InvalidConfigurationException;

/**
 * Interface PasswordCryptRepositoryInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\PasswordCrypt
 */
interface PasswordCryptRepositoryInterface
{
    /**
     * @param User $user
     * @return PasswordCryptInterface
     * @throws InvalidConfigurationException
     */
    public function getByUser(User $user): PasswordCryptInterface;

    /**
     * @param string $passwordEncryptType
     * @return PasswordCryptInterface
     * @throws InvalidConfigurationException
     */
    public function getByEncryptType(string $passwordEncryptType): PasswordCryptInterface;

    /**
     * @return PasswordCryptInterface
     * @throws InvalidConfigurationException
     */
    public function getDefault(): PasswordCryptInterface;

    /**
     * Returns a list of available encryption types
     * @return string[]
     */
    public function getEncryptionTypes(): array;
}
