<?php

/**
 * Class Manager
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 */

namespace Sso\WebserviceBundle\Security\Api;

use Sso\WebserviceBundle\Logger\ProcessDetails;
use Sso\WebserviceBundle\Security\Configuration\AccessConfiguration;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Symfony\Bridge\Monolog\Logger;
use Sso\WebserviceBundle\ErrorHandler\Manager as ErrorHandler;
use Sso\WebserviceBundle\ServiceCommand;
use Sso\Tools\UserIdentifierBundle\Api\ControllerInterface as IdpController;
use Sso\WebserviceBundle\Database\Manager as DatabaseManager;

/**
 * Class Manager
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       www.life-style.de
 * @package    Sso\WebserviceBundle\Security\Api
 */
class Manager
{

    /**
     * @var array
     */
    protected $setter;

    /**
     * @var Container
     */
    private $container;

    /**
     * @var ErrorHandler
     */
    private $errorHandler;

    /**
     * @var \Sso\Tools\UserIdentifierBundle\Api\ControllerInterface
     */
    private $userService;

    /**
     * @var \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    private $symfonyValidator;

    /**
     * Manager constructor.
     * @param Container $container
     */
    public function __construct(
        Container $container,
        ErrorHandler $errorHandler,
        IdpController $userService,
        ServiceCommand $serviceCommand
    ) {
        $this->container = $container;
        $this->serviceCommand = $serviceCommand;
        $this->errorHandler = $errorHandler;
        $this->userService = $userService;
        $this->symfonyValidator = $this->container->get('validator');
    }

    /**
     * @return Factory\WebserviceFactory
     */
    public function factoryWebservice()
    {
        return isset($this->setter[__METHOD__]) ? $this->setter[__METHOD__] : ($this->setter[__METHOD__] = new Factory\WebserviceFactory());
    }

    /**
     * @return Firewall\Factory
     */
    public function firewall()
    {
        return isset($this->setter[__METHOD__]) ? $this->setter[__METHOD__] : ($this->setter[__METHOD__] = new Firewall\Factory($this));
    }

    /**
     * @return \Sso\Tools\UserIdentifierBundle\Api\ControllerInterface
     */
    public function userService()
    {
        return $this->userService;
    }

    /**
     * JMS Serializer
     *
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }

    /**
     * @return \Symfony\Component\Validator\Validator\ValidatorInterface
     */
    public function validator()
    {
        return $this->symfonyValidator;
    }

    /**
     * @return ServiceCommand
     */
    public function getServiceCommand()
    {
        return $this->serviceCommand;
    }

    /**
     * @return Logger
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     * Database manager
     *
     * @return DatabaseManager
     */
    public function database()
    {
        return $this->container->get('service_database_manager');
    }

    /**
     * @return ErrorHandler
     */
    public function getErrorHandler()
    {
        return $this->errorHandler;
    }

    /**
     * @return \Sso\WebserviceBundle\FeatureToggle\FeatureToggle
     */
    public function featureToggle()
    {
        return $this->container->get('webservice.feature_toggle.feature_toggle');
    }

    /**
     * @return ProcessDetails
     */
    public function processDetails()
    {
        return $this->container->get('sso_webservice.logger.process_details');
    }

    /**
     * @return AccessConfiguration
     */
    public function accessConfiguration(): AccessConfiguration
    {
        return $this->container->get('sso_webservice.security_configuration.access_configuration');
    }
}
