<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Security\Authorisation;

use Sso\WebserviceBundle\Security\Authentication\Token\WsFirewallToken;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

/**
 * Class ApplicationAuthorisation
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Security\Authorisation
 */
class ApplicationAuthorisation
{
    /**
     * @var array
     */
    private $applicationRolesRead = [];

    /**
     * @var array
     */
    private $applicationRolesWrite = [];

    /**
     * ApplicationAuthorisation constructor.
     * @param TokenStorageInterface $securityTokenStorage
     */
    public function __construct(TokenStorageInterface $securityTokenStorage)
    {
        $securityToken = $securityTokenStorage->getToken();
        if ($securityToken instanceof WsFirewallToken) {
            $this->applicationRolesRead = $securityToken->getUserWsRolesRead();
            $this->applicationRolesWrite = $securityToken->getUserWsRolesWrite();
        }
    }

    /**
     * @param string $applicationName
     * @return bool
     */
    public function hasReadAccess($applicationName)
    {
        return in_array($applicationName, $this->applicationRolesRead);
    }

    /**
     * @param string $applicationName
     * @return bool
     */
    public function hasWriteAccess($applicationName)
    {
        return in_array($applicationName, $this->applicationRolesWrite);
    }
}
