<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Security\Authorisation;

use Sso\WebserviceBundle\Entity\Webservice\Type\User;

/**
 * Interface UserAuthorizationInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Security\Authorisation
 */
interface UserAuthorizationInterface
{
    /**
     * @param User $user
     * @return bool
     */
    public function canUpdate(User $user): bool;

    /**
     * @param User $user
     * @return bool
     */
    public function canShow(User $user): bool;

    /**
     * @param User $user
     * @return bool
     */
    public function canDelete(User $user): bool;
}
