<?php

/**
 * Class ServiceUser
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Security\Model\Request;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ApplicationUser
 *
 * Optional details about the user behind an application but not the
 * service consumer. For details about the service consumer @see ServiceTrigger
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Security\Model\Request
 */
class ApplicationUser
{
    /**
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 128,
     *      max = 128,
     *      minMessage = "UserIdentifier must be at least {{ limit }} characters long",
     *      maxMessage = "UserIdentifier cannot be bigger than {{ limit }} characters",
     *      exactMessage = "UserIdentifier should have exactly {{ limit }} characters"
     * )
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("string")
     * @var string
     */
    protected $userIdentifier;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 1,
     *      max = 128,
     *      minMessage = "Username must be at least {{ limit }} characters long",
     *      maxMessage = "Username cannot be bigger than {{ limit }} characters"
     * )
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @var string
     */
    protected $userName;

    /**
     * @return string
     */
    public function getUserIdentifier(): string
    {
        return $this->userIdentifier;
    }

    /**
     * @param string $userIdentifier
     */
    public function setUserIdentifier(string $userIdentifier): void
    {
        $this->userIdentifier = $userIdentifier;
    }

    /**
     * @return string
     */
    public function getUserName(): string
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     */
    public function setUserName(string $userName): void
    {
        $this->userName = $userName;
    }
}
