<?php

/**
 * Class Credentials
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Security\Model\Request;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Credentials
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Security\Model\Request
 */
class Credentials
{

    /**
     * @Serializer\SerializedName("ServiceProvider")
     * @Serializer\Type("Sso\WebserviceBundle\Security\Model\Request\ServiceProvider")
     * @var ServiceProvider
     */
    protected $serviceProvider;

    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("ServiceTrigger")
     * @Serializer\Type("Sso\WebserviceBundle\Security\Model\Request\ServiceTrigger")
     * @var ServiceTrigger
     */
    protected $serviceTrigger;

    /**
     * @Assert\NotNull(groups={"accessRestricted"})
     * @Assert\Valid
     *
     * @Serializer\SerializedName("ApplicationUser")
     * @Serializer\Type("Sso\WebserviceBundle\Security\Model\Request\ApplicationUser")
     * @var ApplicationUser|null
     */
    protected $applicationUser;

    /**
     * @Serializer\SerializedName("ServiceCountry")
     * @Serializer\Type("Sso\WebserviceBundle\Security\Model\Request\ServiceCountry")
     * @var ServiceCountry
     */
    protected $serviceCountry;

    /**
     *
     * @param ServiceProvider $serviceProvider
     */
    public function addServiceProvider(ServiceProvider $serviceProvider)
    {
        $this->serviceProvider = $serviceProvider;
    }

    /**
     *
     * @return ServiceProvider
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }

    /**
     *
     * @param ServiceTrigger $serviceTrigger
     */
    public function addServiceTrigger(ServiceTrigger $serviceTrigger)
    {
        $this->serviceTrigger = $serviceTrigger;
    }

    /**
     *
     * @return ServiceTrigger
     */
    public function getServiceTrigger()
    {
        return $this->serviceTrigger;
    }

    /**
     * @return ApplicationUser|null
     */
    public function getApplicationUser(): ?ApplicationUser
    {
        return $this->applicationUser;
    }

    /**
     * @param ApplicationUser|null $applicationUser
     */
    public function setApplicationUser(?ApplicationUser $applicationUser): void
    {
        $this->applicationUser = $applicationUser;
    }

    /**
     *
     * @param ServiceCountry $serviceCountry
     */
    public function addServiceCountry(ServiceCountry $serviceCountry)
    {
        $this->serviceCountry = $serviceCountry;
    }

    /**
     *
     * @return ServiceCountry
     */
    public function getServiceCountry()
    {
        return $this->serviceCountry;
    }

    /**
     *
     * @param string $serviceToken
     * @param string $serviceName
     * @param string $userIdentifier
     * @param string $code
     */
    public function setCredentialsData($serviceToken, $serviceName, $userIdentifier, $code)
    {

        $serviceProvider = new ServiceProvider();
        $serviceProvider->setServiceToken($serviceToken);
        $serviceProvider->setServiceName($serviceName);
        $this->addServiceProvider($serviceProvider);

        $serviceTrigger = new ServiceTrigger();
        $serviceTrigger->setUserIdentifier($userIdentifier);
        $this->addServiceTrigger($serviceTrigger);

        $serviceCountry = new ServiceCountry();
        $serviceCountry->setCode($code);
        $this->addServiceCountry($serviceCountry);

    }
}
