<?php

/**
 * Class ServiceProvider
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Security\Model\Request;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ServiceProvider
 *
 * @Serializer\XmlRoot("ServiceProvider")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Security\Model\Request
 */
class ServiceProvider
{

    /**
     * @Serializer\SerializedName("ServiceToken")
     * @Serializer\Type("string")
     * @var string
     */
    protected $serviceToken;

    /**
     * @Serializer\SerializedName("ServiceName")
     * @Serializer\Type("string")
     * @var string
     */
    protected $serviceName;

    /**
     * @param string $serviceName
     */
    public function setServiceName($serviceName)
    {
        $this->serviceName = $serviceName;
    }

    /**
     * @return string
     */
    public function getServiceToken()
    {
        return $this->serviceToken;
    }

    /**
     * @param string $serviceToken
     */
    public function setServiceToken($serviceToken)
    {
        $this->serviceToken = $serviceToken;
    }

    /**
     * @return string
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
}
