<?php

/**
 * Class ServiceTrigger
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Security\Model\Request;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ServiceTrigger
 *
 * Required details about the service consumer - the application itself. For details about the
 * user behind an application @see ApplicationUser
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Security\Model\Request
 */
class ServiceTrigger
{

    /**
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 128,
     *      max = 128,
     *      minMessage = "UserIdentifier must be at least {{ limit }} characters long",
     *      maxMessage = "UserIdentifier cannot be bigger than {{ limit }} characters",
     *      exactMessage = "UserIdentifier should have exactly {{ limit }} characters"
     * )
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("string")
     * @var string
     */
    protected $userIdentifier;

    /**
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 1,
     *      max = 128,
     *      minMessage = "Username must be at least {{ limit }} characters long",
     *      maxMessage = "Username cannot be bigger than {{ limit }} characters"
     * )
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @var string
     */
    protected $userName;

    /**
     *
     * @param string $userIdentifier
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = $userIdentifier;
    }

    /**
     *
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return ServiceTrigger
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;

        return $this;
    }
}
