<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle;

use Sso\WebserviceBundle\Services\RequestInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class ServiceRequest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle
 */
final class ServiceRequest implements RequestInterface
{
    /**
     * @var string|resource
     */
    private $requestBody;

    /**
     * ServiceRequest constructor.
     * @param resource|string $requestBody
     */
    private function __construct($requestBody)
    {
        $this->requestBody = $requestBody;
    }

    /**
     * @param Request $request
     * @return ServiceRequest
     */
    public static function createFromRequest(Request $request)
    {
        return new self($request->getContent());
    }

    /**
     * @return string|resource
     */
    public function getRequestBody()
    {
        return $this->requestBody;
    }
}
