<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services;

use Sso\WebserviceBundle\Api\ApiVersionInterface;
use InvalidArgumentException;

/**
 * Class ApiVersionInflector
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services
 */
final class ApiVersionInflector implements ApiVersionInflectorInterface
{
    /**
     * @var ApiVersionInterface
     */
    private $apiVersion;

    /**
     * ApiVersionInflector constructor.
     * @param ApiVersionInterface $apiVersion
     */
    public function __construct(ApiVersionInterface $apiVersion)
    {
        $this->apiVersion = $apiVersion;
    }

    /**
     * Returns class name for versioned class
     * @param string $namespace
     * @param string $className
     * @return string
     */
    public function inflect($namespace, $className)
    {
        $class = $namespace . '\\' . $this->apiVersion->toString() . '\\' . $className;

        if (preg_match('#\s#', $class)) {
            throw new InvalidArgumentException(sprintf(
                'A class name should not contain any whitespaces! (Class name "%s")',
                $class
            ));
        }

        return $class;
    }

    /**
     * Returns service name for versioned service
     *
     * @param string $prefix
     * @param string $serviceName
     * @return string
     */
    public function inflectService($prefix, $serviceName)
    {
        $service = $prefix . '_version' . $this->apiVersion->toInt() . '.' . $serviceName;

        if (preg_match('#\s#', $service)) {
            throw new InvalidArgumentException(sprintf(
                'A service name should not contain any whitespaces! (Service "%s")',
                $service
            ));
        }

        return $service;
    }
}
