<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\Application\All\Response\Version3;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\Application\All\Response\Version3
 */
final class AttributeType
{
    /**
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("string")
     */
    private $type;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     */
    private $name;
    /**
     * @Serializer\SerializedName("DisplayType")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $displayType;

    /**
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\Application\All\Response\Version3\AttributeTypeOption>")
     * @Serializer\XmlList(inline=true, entry="AttributeOption")
     *
     * @var AttributeTypeOption[]|null
     */
    private $attributeOptions;

    /**
     * @param string $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @param string|null $displayType
     */
    public function setDisplayType(?string $displayType): void
    {
        $this->displayType = $displayType;
    }

    /**
     * @param AttributeTypeOption $option
     */
    public function addAttributeTypeOption(AttributeTypeOption $option): void
    {
        $this->attributeOptions[] = $option;
    }
}
