<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\Application\All\Response\Version3;

use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsInterface;
use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;

/**
 * Class Response
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\Application\All\Response\Version3
 * @Serializer\XmlRoot(name="SsoResponse")
 */
class Response
{
    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     * @var string
     */
    private $code;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("ScriptTimeSec")
     * @Serializer\Type("double")
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("Application")
     * @Serializer\Type("Sso\WebserviceBundle\Services\Application\All\Response\Version3\Application")
     * @var Application
     */
    private $application;

    /**
     * @Serializer\XmlList(inline = true)
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->date = new \DateTime();
        $this->trackid = ApiException::getTrackId();
    }

    /**
     * @param string $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }

    /**
     * @param string $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }

    /**
     * @param Application $application
     */
    public function setApplication($application)
    {
        $this->application = $application;
    }

    /**
     * @param ErrorsInterface $errors
     */
    public function setErrors($errors)
    {
        $this->errors = $errors;
    }
}
