<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\Application\All\ResponseData;

/**
 * Class Applications
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\Application\All\ResponseData
 */
class Applications
{
    /**
     * @var integer
     */
    private $offset;

    /**
     * @var integer
     */
    private $limit;

    /**
     * @var string
     */
    private $orderBy;

    /**
     * @var string
     */
    private $orderDir;

    /**
     * @var integer
     */
    private $fullResponse;

    /**
     * @var integer
     */
    private $count;

    /**
     * @var ApplicationType[]
     */
    private $applications = [];

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
    }

    /**
     * @return string
     */
    public function getOrderBy()
    {
        return $this->orderBy;
    }

    /**
     * @param string $orderBy
     */
    public function setOrderBy($orderBy)
    {
        $this->orderBy = $orderBy;
    }

    /**
     * @return string
     */
    public function getOrderDir()
    {
        return $this->orderDir;
    }

    /**
     * @param string $orderDir
     */
    public function setOrderDir($orderDir)
    {
        $this->orderDir = $orderDir;
    }

    /**
     * @return int
     */
    public function getFullResponse()
    {
        return $this->fullResponse;
    }

    /**
     * @param int $fullResponse
     */
    public function setFullResponse($fullResponse)
    {
        $this->fullResponse = $fullResponse;
    }

    /**
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param int $count
     */
    public function setCount($count)
    {
        $this->count = $count;
    }

    /**
     * @return ApplicationType[]
     */
    public function getApplications()
    {
        return $this->applications;
    }

    /**
     * @param ApplicationType $applicationType
     */
    public function addApplication(ApplicationType $applicationType)
    {
        $this->applications[] = $applicationType;
    }
}
