<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Request;

use Sso\WebserviceBundle\Services\ApiVersionInflectorInterface;
use Sso\WebserviceBundle\Services\ApplicationAttribute\Add\RequestParserInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class RequestFactory
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Sso\WebserviceBundle\Services\ApplicationAttribute\Add\Request
 */
class RequestFactory
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var ApiVersionInflectorInterface
     */
    private $versionInflector;

    /**
     * RequestFactory constructor.
     * @param ContainerInterface $container
     * @param ApiVersionInflectorInterface $versionInflector
     */
    public function __construct(ContainerInterface $container, ApiVersionInflectorInterface $versionInflector)
    {
        $this->container = $container;
        $this->versionInflector = $versionInflector;
    }

    /**
     * @return RequestParserInterface
     */
    public function create(): RequestParserInterface
    {
        $serviceId = $this->versionInflector->inflect(__NAMESPACE__, 'RequestParser');
        return $this->container->get($serviceId);
    }
}
