<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\PasswordPolicy\Show\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\PasswordPolicy\Show\Request\Version2
 */
final class Request
{

    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("PasswordPolicy")
     * @Serializer\Type("Sso\WebserviceBundle\Services\PasswordPolicy\Show\Request\Version2\PasswordPolicy")
     * @var PasswordPolicy
     */
    private $passwordPolicy;

    /**
     * @return PasswordPolicy
     */
    public function getPasswordPolicy()
    {
        return $this->passwordPolicy;
    }
}


