<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version2;

use Sso\WebserviceBundle\Api\ApiManagerInterface;

/**
 * Class Factory
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version2
 */
final class Factory
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * Factory constructor.
     * @param ApiManagerInterface $apiM
     */
    public function __construct(ApiManagerInterface $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return ResponseBuilder
     */
    public function responseBuilder()
    {
        return new ResponseBuilder($this->apiM->serializer(), $this, $this->apiM->errorHandler());
    }

    /**
     * @return Response
     */
    public function response()
    {
        return new Response();
    }

    /**
     * @return Show
     */
    public function show()
    {
        return new Show();
    }

    /**
     * @return PasswordPolicy
     */
    public function passwordPolicy()
    {
        return new PasswordPolicy();
    }

    /**
     * @return UserType
     */
    public function userType()
    {
        return new UserType();
    }

    /**
     * @return PasswordPolicyType
     */
    public function passwordPolicyType()
    {
        return new PasswordPolicyType();
    }

    /**
     * @return TranslationType
     */
    public function translationType()
    {
        return new TranslationType();
    }

    /**
     * @return double
     */
    public function scriptTimeSeconds(){
        return $this->apiM->scriptTimeSeconds();
    }
}
