<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class PasswordPolicyType
 * @package Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3
 */
final class PasswordPolicyType
{
    /**
     * @Serializer\SerializedName("PolicyId")
     * @Serializer\Type("string")
     * @var string
     */
    private $policyId;

    /**
     * @Serializer\SerializedName("Title")
     * @Serializer\Type("string")
     * @var string
     */
    private $title;

    /**
     * @Serializer\SerializedName("ValidityDuration")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $validityDuration;

    /**
     * @Serializer\SerializedName("ValidityDurationErrorMessages")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3\TranslationType>")
     * @Serializer\XmlList(inline = false, entry = "Translation")
     * @var TranslationType[]|ArrayCollection
     */
    private $validityDurationErrorMessages = [];

    /**
     * @Serializer\SerializedName("HistorySize")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $historySize;

    /**
     * @Serializer\SerializedName("HistorySizeErrorMessages")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3\TranslationType>")
     * @Serializer\XmlList(inline = false, entry = "Translation")
     * @var TranslationType[]|ArrayCollection
     */
    private $historySizeErrorMessages = [];

    /**
     * @Serializer\SerializedName("EditDistance")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $editDistance;

    /**
     * @Serializer\SerializedName("EditDistanceErrorMessages")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3\TranslationType>")
     * @Serializer\XmlList(inline = false, entry = "Translation")
     * @var TranslationType[]|ArrayCollection
     */
    private $editDistanceErrorMessages = [];

    /**
     * @Serializer\SerializedName("ChangeDelay")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $changeDelay;

    /**
     * @Serializer\SerializedName("ChangeDelayErrorMessages")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3\TranslationType>")
     * @Serializer\XmlList(inline = false, entry = "Translation")
     * @var TranslationType[]|ArrayCollection
     */
    private $changeDelayErrorMessages = [];

    /**
     * @Serializer\SerializedName("PolicyDescription")
     * @Serializer\Type("string")
     * @var string
     */
    private $policyDescription;

    /**
     * @Serializer\SerializedName("ErrorMessages")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3\TranslationType>")
     * @Serializer\XmlList(inline = false, entry = "Translation")
     * @var TranslationType[]|ArrayCollection
     */
    private $errorMessages = [];

    /**
     * @Serializer\SerializedName("Default")
     * @Serializer\Type("boolean")
     * @var bool
     */
    private $isDefault;

    /**
     * @Serializer\SerializedName("PolicyValidations")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3\PasswordPolicyValidationsType>")
     * @Serializer\XmlList(inline = false, entry = "Validation")
     * @var PasswordPolicyValidationsType[]|ArrayCollection
     */
    private $passwordPolicyValidations;

    /**
     * PasswordPolicyType constructor.
     */
    public function __construct()
    {
        $this->validityDurationErrorMessages = new ArrayCollection();
        $this->historySizeErrorMessages = new ArrayCollection();
        $this->editDistanceErrorMessages = new ArrayCollection();
        $this->changeDelayErrorMessages = new ArrayCollection();
        $this->errorMessages = new ArrayCollection();
        $this->passwordPolicyValidations = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getPolicyId()
    {
        return $this->policyId;
    }

    /**
     * @param string $policyId
     * @return PasswordPolicyType
     */
    public function setPolicyId($policyId)
    {
        $this->policyId = $policyId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return PasswordPolicyType
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return int
     */
    public function getValidityDuration()
    {
        return $this->validityDuration;
    }

    /**
     * @param int $validityDuration
     * @return PasswordPolicyType
     */
    public function setValidityDuration($validityDuration)
    {
        $this->validityDuration = $validityDuration;
        return $this;
    }

    /**
     * @return array
     */
    public function getValidityDurationErrorMessages()
    {
        return $this->validityDurationErrorMessages;
    }

    /**
     * @param TranslationType $validityDurationErrorMessages
     * @return PasswordPolicyType
     */
    public function addValidityDurationErrorMessages(TranslationType $validityDurationErrorMessages)
    {
        if (!$this->validityDurationErrorMessages->contains($validityDurationErrorMessages)) {
            $this->validityDurationErrorMessages->add($validityDurationErrorMessages);
        }
        return $this;
    }

    /**
     * @return int
     */
    public function getHistorySize()
    {
        return $this->historySize;
    }

    /**
     * @param int $historySize
     * @return PasswordPolicyType
     */
    public function setHistorySize($historySize)
    {
        $this->historySize = $historySize;
        return $this;
    }

    /**
     * @return array
     */
    public function getHistorySizeErrorMessages()
    {
        return $this->historySizeErrorMessages;
    }

    /**
     * @param TranslationType $historySizeErrorMessages
     * @return PasswordPolicyType
     */
    public function addHistorySizeErrorMessages(TranslationType $historySizeErrorMessages)
    {
        if (!$this->historySizeErrorMessages->contains($historySizeErrorMessages)) {
            $this->historySizeErrorMessages->add($historySizeErrorMessages);
        }

        return $this;
    }

    /**
     * @return int
     */
    public function getEditDistance()
    {
        return $this->editDistance;
    }

    /**
     * @param int $editDistance
     * @return PasswordPolicyType
     */
    public function setEditDistance($editDistance)
    {
        $this->editDistance = $editDistance;
        return $this;
    }

    /**
     * @return array
     */
    public function getEditDistanceErrorMessages()
    {
        return $this->editDistanceErrorMessages;
    }

    /**
     * @param TranslationType $editDistanceErrorMessages
     * @return PasswordPolicyType
     */
    public function addEditDistanceErrorMessages(TranslationType $editDistanceErrorMessages)
    {
        if (!$this->editDistanceErrorMessages->contains($editDistanceErrorMessages)) {
            $this->editDistanceErrorMessages->add($editDistanceErrorMessages);
        }

        return $this;
    }

    /**
     * @return int
     */
    public function getChangeDelay()
    {
        return $this->changeDelay;
    }

    /**
     * @param int $changeDelay
     * @return PasswordPolicyType
     */
    public function setChangeDelay($changeDelay)
    {
        $this->changeDelay = $changeDelay;
        return $this;
    }

    /**
     * @return array
     */
    public function getChangeDelayErrorMessages()
    {
        return $this->changeDelayErrorMessages;
    }

    /**
     * @param TranslationType $changeDelayErrorMessages
     * @return PasswordPolicyType
     */
    public function addChangeDelayErrorMessages(TranslationType $changeDelayErrorMessages)
    {
        if (!$this->changeDelayErrorMessages->contains($changeDelayErrorMessages)) {
            $this->changeDelayErrorMessages->add($changeDelayErrorMessages);
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getPolicyDescription()
    {
        return $this->policyDescription;
    }

    /**
     * @param string $policyDescription
     * @return PasswordPolicyType
     */
    public function setPolicyDescription($policyDescription)
    {
        $this->policyDescription = $policyDescription;
        return $this;
    }

    /**
     * @return array
     */
    public function getErrorMessages()
    {
        return $this->errorMessages;
    }

    /**
     * @param TranslationType $errorMessages
     * @return PasswordPolicyType
     */
    public function addErrorMessages(TranslationType $errorMessages)
    {
        if (!$this->errorMessages->contains($errorMessages)) {
            $this->errorMessages->add($errorMessages);
        }


        return $this;
    }

    /**
     * @return bool
     */
    public function isDefault()
    {
        return $this->isDefault;
    }

    /**
     * @param bool $isDefault
     * @return PasswordPolicyType
     */
    public function setIsDefault($isDefault)
    {
        $this->isDefault = $isDefault;
        return $this;
    }

    /**
     * @return PasswordPolicyValidationsType[]|ArrayCollection
     */
    public function getPasswordPolicyValidations()
    {
        return $this->passwordPolicyValidations;
    }

    /**
     * @param PasswordPolicyValidationsType|ArrayCollection $passwordPolicyValidations
     * @return PasswordPolicyType
     */
    public function addPasswordPolicyValidation(PasswordPolicyValidationsType $passwordPolicyValidation)
    {
        if (!$this->passwordPolicyValidations->contains($passwordPolicyValidation)) {
            $this->passwordPolicyValidations->add($passwordPolicyValidation);
        }

        return $this;
    }
}
