<?php

/**
 * Class TranslationType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class TranslationType
 * @package Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3
 */
final class TranslationType
{
    /**
     * @Serializer\SerializedName("Language")
     * @Serializer\Type("string")
     * @var string
     */
    private $language;

    /**
     * @Serializer\SerializedName("Message")
     * @Serializer\Type("string")
     * @var string
     */
    private $message;

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param string $language
     * @return TranslationType
     */
    public function setLanguage($language)
    {
        $this->language = $language;
        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return TranslationType
     */
    public function setMessage($message)
    {
        $this->message = $message;
        return $this;
    }
}
