<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package Sso\WebserviceBundle\Services\PasswordPolicy\Show\Response\Version3
 */
final class UserType
{
    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     * @var string
     */
    private $email;

    /**
     * @Serializer\SerializedName("Firstname")
     * @Serializer\Type("string")
     * @var string
     */
    private $firstname;

    /**
     * @Serializer\SerializedName("Lastname")
     * @Serializer\Type("string")
     * @var string
     */
    private $lastname;

    /**
     * @param array $userAttributes
     * @return UserType
     */
    public function setFromArray(array $userAttributes)
    {
        foreach ($userAttributes as $name => $value) {
            $method = 'set'.ucfirst($name);
            if (!method_exists($this, $method)) {
                throw new \BadMethodCallException(sprintf(
                    'Unable to create user response model %s! Userattribute %s does not exist.',
                    self::class,
                    $name
                ));
            }
            $this->$method($value);
        }

        return $this;
    }

    /**
     * @param string $guid
     * @return UserType
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @param string $username
     * @return UserType
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @param string $email
     * @return UserType
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @param string $firstname
     * @return UserType
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;
        return $this;
    }

    /**
     * @param string $lastname
     * @return UserType
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;
        return $this;
    }
}
