<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\PasswordPolicy\Show\ResponseData;

use Sso\WebserviceBundle\Entity\Webservice\Type\PasswordPolicyValidations as PasswordPolicyValidationsModel;

/**
 * Class PasswordPolicyValidations
 * @package Sso\WebserviceBundle\Services\PasswordPolicy\Show\ResponseData
 */
final class PasswordPolicyValidations
{
    /**
     * @var integer
     */
    private $orderId;

    /**
     * @var string
     */
    private $regEx;

    /**
     * @var array
     */
    private $errorMessages = [];

    /**
     * @var array
     */
    private $hintMessages = [];

    /**
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }

    /**
     * @param int $orderId
     * @return PasswordPolicyValidations
     */
    public function setOrderId($orderId)
    {
        $this->orderId = $orderId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRegEx()
    {
        return $this->regEx;
    }

    /**
     * @param string $regEx
     * @return PasswordPolicyValidations
     */
    public function setRegEx($regEx)
    {
        $this->regEx = $regEx;
        return $this;
    }

    /**
     * @return array
     */
    public function getErrorMessages()
    {
        return $this->errorMessages;
    }

    /**
     * @param array $errorMessages
     * @return PasswordPolicyValidations
     */
    public function setErrorMessages($errorMessages)
    {
        $this->errorMessages[] = $errorMessages;
        return $this;
    }

    /**
     * @return array
     */
    public function getHintMessages()
    {
        return $this->hintMessages;
    }

    /**
     * @param array $hintMessages
     * @return PasswordPolicyValidations
     */
    public function setHintMessages($hintMessages)
    {
        $this->hintMessages[] = $hintMessages;
        return $this;
    }
}
