<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      shgb
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Add\Request\Version2;

use JMS\Serializer\SerializerInterface;
use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use Sso\WebserviceBundle\Services\User\Add\RequestParserInterface;
use Sso\WebserviceBundle\Services\User\Add\RequestData\Factory as RequestDataFactory;
use InvalidArgumentException;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Sso\WebserviceBundle\Api\Mapper\Index as AutoMapper;

/**
 * Class RequestParser
 *
 * @copyright   2016 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 * @package     Sso\WebserviceBundle\Services\User\Add\Request\Version2
 */
final class RequestParser implements RequestParserInterface
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var RequestDataFactory
     */
    private $factory;

    /**
     * @var ErrorHandlerInterface
     */
    private $errorHandler;

    /**
     * @var ValidatorInterface
     */
    private $validator;

    /**
     * @var AutoMapper
     */
    private $autoMapper;

    /**
     * RequestParser constructor.
     * @param SerializerInterface $serializer
     * @param RequestDataFactory $factory
     * @param ErrorHandlerInterface $errorHandler
     * @param ValidatorInterface $validator
     * @param AutoMapper $autoMapper
     */
    public function __construct(SerializerInterface $serializer, RequestDataFactory $factory, ErrorHandlerInterface $errorHandler, ValidatorInterface $validator, AutoMapper $autoMapper)
    {
        $this->serializer = $serializer;
        $this->factory = $factory;
        $this->errorHandler = $errorHandler;
        $this->validator = $validator;
        $this->autoMapper = $autoMapper;
    }

    /**
     * @param string $content
     * @return \Sso\WebserviceBundle\Services\User\Add\RequestData\User
     */
    public function parse($content)
    {

        /** @var Request $request */
        $request = $this->serializer->deserialize($content, Request::class, 'xml');

        if (!($request instanceof Request)) {
            throw new InvalidArgumentException();
        }

        $user = $this->factory->user();
        if (!$this->validate($request)) {
            return $user;
        }

        //now set the requestDTO
        $user = $this->autoMapper->modelInToModelOut($request->getUser()->getAdd()->getValue()->getUserType(), $user);
        
        return $user;
    }

    /**
     * @param Request $request
     * @return bool
     */
    private function validate(Request $request)
    {
        $validationErrors = $this->validator->validate($request);
        if (count($validationErrors) === 0) {
            return true;
        }
        foreach ($validationErrors as $error) {
            $message = $error->getPropertyPath().': '.$error->getMessage();
            $this->errorHandler->addError(400, $message, $message, $message, $message);
        }

        return false;
    }
}
