<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Add\RequestData;

/**
 * Class User
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\User\Add\RequestData
 */
final class User
{
    const BOOLEAN_TRUE = true;
    const BOOLEAN_FALSE = false;

    /**
     * @var string|null
     */
    private $email;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $firstname;

    /**
     * @var string
     */
    private $lastname;

    /**
     * @var string
     */
    private $password;

    /**
     * @var boolean
     */
    private $active;

    /**
     * @var string
     */
    private $authId;

    /**
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @var boolean
     */
    private $mfaEnabled;

    /**
     * @var string
     */
    private $passwordPolicy;

    /**
     * @var \DateTime|null
     */
    private $lastPasswordChange;

    /**
     * @var integer
     */
    private $passwordExpired;

    /**
     * @var string
     */
    private $passwordEncryptType;

    /**
     * @var array|string[]|null
     */
    private $userGroups;

    /**
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return User
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return User
     */
    public function setUsername($username)
    {
        $this->username = $username;

        return $this;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     * @return User
     */
    public function setFirstname($firstname)
    {
        $this->firstname = $firstname;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     * @return User
     */
    public function setLastname($lastname)
    {
        $this->lastname = $lastname;

        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return User
     */
    public function setPassword($password)
    {
        $this->password = $password;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param boolean $active
     * @return User
     */
    public function setActive($active)
    {
        $this->active = $active == 1 ? static::BOOLEAN_TRUE : static::BOOLEAN_FALSE;

        return $this;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @param string $authId
     * @return User
     */
    public function setAuthId($authId)
    {
        $this->authId = $authId;

        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchAttributes
     * @return User
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = $ldapSearchAttributes;

        return $this;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @param string $ldapSearchValue
     * @return User
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = $ldapSearchValue;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param boolean $mfaEnabled
     * @return User
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled == 1 ? static::BOOLEAN_TRUE : static::BOOLEAN_FALSE;

        return $this;
    }

    /**
     * @return string
     */
    public function getPasswordPolicy()
    {
        return $this->passwordPolicy;
    }

    /**
     * @param string $passwordPolicy
     * @return User
     */
    public function setPasswordPolicy($passwordPolicy)
    {
        $this->passwordPolicy = $passwordPolicy;
        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getLastPasswordChange()
    {
        return $this->lastPasswordChange;
    }

    /**
     * @param \DateTime|null $lastPasswordChange
     * @return User
     */
    public function setLastPasswordChange($lastPasswordChange)
    {
        $this->lastPasswordChange = $lastPasswordChange instanceof \DateTime ? clone $lastPasswordChange : null;
        return $this;
    }

    /**
     * @return int
     */
    public function getPasswordExpired()
    {
        return $this->passwordExpired;
    }

    /**
     * @param int $passwordExpired
     * @return User
     */
    public function setPasswordExpired($passwordExpired)
    {
        $this->passwordExpired = $passwordExpired;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPasswordEncryptType()
    {
        return $this->passwordEncryptType;
    }

    /**
     * @param string|null $passwordEncryptType
     */
    public function setPasswordEncryptType(?string $passwordEncryptType): void
    {
        $this->passwordEncryptType = $passwordEncryptType;
    }

    /**
     * @return array|string[]|null
     */
    public function getUserGroups()
    {
        return $this->userGroups;
    }

    /**
     * @param array|string[]|null $userGroups
     */
    public function setUserGroups($userGroups): void
    {
        $this->userGroups = $userGroups;
    }
}
