<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version2;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Value
 *
 * @Serializer\XmlRoot("Value")
 *
 * @package Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version2
 */
class Value
{
    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version2\ValuePasswordType")
     * @var ValuePasswordType
     */
    protected $userType;

    /**
     * @return ValuePasswordType
     */
    public function getPasswordType()
    {
        return $this->userType;
    }
}
