<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version3;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class User
 *
 * @Serializer\XmlRoot("User")
 *
 * @package Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version3
 */
class User
{
    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("ChangePassword")
     * @Serializer\Type("Sso\WebserviceBundle\Services\User\ChangePassword\Request\Version3\ChangePassword")
     * @var ChangePassword
     */
    protected $changePassword;

    /**
     * @return ChangePassword
     */
    public function getChangePassword()
    {
        return $this->changePassword;
    }
}
