<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ChangePassword\Response\Version2;

use Sso\WebserviceBundle\Api\ApiManagerInterface;

/**
 * Class Factory
 * @package Sso\WebserviceBundle\Services\User\ChangePassword\Response\Version2
 */
class Factory
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * Factory constructor.
     * @param ApiManagerInterface $apiM
     */
    public function __construct(ApiManagerInterface $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return ResponseBuilder
     */
    public function responseBuilder()
    {
        return new ResponseBuilder($this->apiM->serializer(), $this, $this->apiM->errorHandler());
    }

    /**
     * @return Response
     */
    public function response()
    {
        return new Response();
    }

    /**
     * @return User
     */
    public function user()
    {
        return new User();
    }

    /**
     * @return ChangePassword
     */
    public function changePassword()
    {
        return new ChangePassword();
    }
    
    /**
     * @return double
     */
    public function scriptTimeSeconds()
    {
        return $this->apiM->scriptTimeSeconds();
    }
}
