<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ChangePassword\Response\Version3;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ChangePassword
 * @package Sso\WebserviceBundle\Services\User\ChangePassword\Response\Version3
 */
class ChangePassword
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Message")
     * @Serializer\Type("string")
     * @var string
     */
    private $message;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return ChangePassword
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return ChangePassword
     */
    public function setMessage($message)
    {
        $this->message = $message;
        return $this;
    }
}
