<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\ResetPassword\Request\Version2;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class ResetPassword
 *
 * @Serializer\XmlRoot("ResetPassword")
 *
 * @package Sso\WebserviceBundle\Services\User\ResetPassword\Request\Version2
 */
class ResetPassword
{
    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("Sso\WebserviceBundle\Services\User\ResetPassword\Request\Version2\Value")
     * @var Value
     */
    protected $value;

    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("Sso\WebserviceBundle\Services\User\ResetPassword\Request\Version2\Key")
     * @var Key
     */
    protected $key;

    /**
     * @return Value
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return Key
     */
    public function getKey()
    {
        return $this->key;
    }
}
